﻿public class RegisterScriptMenu
{
    [DeclareMenu]
    public void MenuFunction()
    {
        Eplan.EplApi.Gui.Menu oMenu = new Eplan.EplApi.Gui.Menu();
        oMenu.AddMenuItem("Wire Processing Center (WPC)", "WPCActionMenu");
    }

    public string WinTempPath;

    [DeclareAction("WPCActionMenu")]
    public void RDAction()
    {
        System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.WaitCursor;
        WinTempPath = GetWinTempPath();

        //Listen aus EplanP8 Exportieren
        //bool ergebnisKabel = ExportList("KabelList.txt", "WI-Cable");
        bool ergebnisAder = ExportList("AderList.txt", "WI-Core");
		
		string WPCPath = "";
		if (ergebnisAder)
		{
			Microsoft.Win32.RegistryKey WPCReg = null;
			try
			{
				WPCReg = Microsoft.Win32.Registry.CurrentUser.OpenSubKey
					("Software\\Weidmueller\\WPC", false);

			    
				
				if (WPCReg == null)
				{
					System.Windows.Forms.MessageBox.Show("WPC is not installed.");
					ergebnisAder = false;
				}
				else
				{
					WPCPath = WPCReg.GetValue("InstallPath", "").ToString();
					bool bWPCToolExists = System.IO.File.Exists(WPCPath+"\\WPC-Tool.exe");
					if (!bWPCToolExists)
						System.Windows.Forms.MessageBox.Show("WPC files not found!");
						
				}
			}
			catch
			{
				System.Windows.Forms.MessageBox.Show("WPC is not installed.");
				System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.Default;
				ergebnisAder = false;
			}
		}
		

        if (ergebnisAder)
        {
			string sArguments = " EPLAN "+ WinTempPath +"AderList.txt";
            System.Diagnostics.Process P = new System.Diagnostics.Process();
            P.StartInfo.FileName = WPCPath + "\\WPC-Tool.exe";
            // hier kann z.B. eine Textdatei mit übergeben werden
            P.StartInfo.Arguments = sArguments;
            P.Start();

            System.Windows.Forms.MessageBox.Show("The Export was successful.", "WPC-Export");

            //while (!p.HasExited)
            //{
            //    System.Threading.Thread.Sleep(100);
            //}

            //Parameter = "\"" + WinTempPath + "p8.rde" + "\" ";
            //if (System.IO.File.Exists(WinTempPath + "speedprint.p8"))
            //    Parameter = "-p " + Parameter;



            System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.Default;
        }
    }

    public string GetWinTempPath()
    {
        return System.IO.Path.GetTempPath();
    }

    public bool ExportList(string sFileName, string sCONFIGSCHEME)
    {
        bool erg = false;
        try
        {
            // Vorgabe Übergabeverzeichnis der Scripte / Einstellungen
            //string sDir = @"C:\Programme\EPLAN\P8\IO_Conf\";
            //===================================================

            // Vorgabe DESTINATIONFILE
            string sDESTINATIONFILE = WinTempPath + sFileName;//"RDTerminalList.txt";
            System.IO.File.Delete(sDESTINATIONFILE);
            //=========================================

            // Vorgabe CONFIGSCHEME
            //string sCONFIGSCHEME = "MPrintPro";


            //=========================================

            // Vorgabe LANGUAGE
            string sLANGUAGE = "de_DE";
            //=========================================

            // OPTIONAL

            // Vorgabe FILTERSCHEME
            string sFILTERSCHEME = "";
            //=========================================

            // Vorgabe SORTSCHEME
            string sSORTSCHEME = "";
            //=========================================


            // Stelle aktuellen Stand von Skripten und Einstellungen her
            // ==============================================================
            //long iRet;
            //if (sDir!="")
            //	iRet =Import_Schema(sDir);


            // aktuelles Projekt ermitteln
            //==========================================
            Eplan.EplApi.ApplicationFramework.ActionManager oMngr = new Eplan.EplApi.ApplicationFramework.ActionManager();
            Eplan.EplApi.ApplicationFramework.Action oSelSetAction = oMngr.FindAction("selectionset");

            string sProjekt = "";
            if (oMngr != null)
            {

                Eplan.EplApi.ApplicationFramework.ActionCallingContext ctx = new Eplan.EplApi.ApplicationFramework.ActionCallingContext();
                ctx.AddParameter("TYPE", "PROJECT");
                bool sRet = oSelSetAction.Execute(ctx);

                if (sRet)
                {
                    ctx.GetParameter("PROJECT", ref sProjekt);

                }
            }

            if (sProjekt == "")
                return erg;


            // Starte Export
            //============================================================
            Eplan.EplApi.ApplicationFramework.ActionCallingContext aExport = new Eplan.EplApi.ApplicationFramework.ActionCallingContext();
            aExport.AddParameter("PROJECTNAME", sProjekt);
            aExport.AddParameter("CONFIGSCHEME", sCONFIGSCHEME);
            aExport.AddParameter("LANGUAGE", sLANGUAGE);
            aExport.AddParameter("DESTINATIONFILE", sDESTINATIONFILE);


            if (sFILTERSCHEME != "")
                aExport.AddParameter("FILTERSCHEME", sFILTERSCHEME);

            if (sSORTSCHEME != "")
                aExport.AddParameter("SORTSCHEME", sSORTSCHEME);

            //aExport.AddParameter("RECREPEAT ","1");
            //aExport.AddParameter("TASKREPEAT ","1");
            //aExport.AddParameter("HOWOUTPUT","1");
            try
            {
                Eplan.EplApi.ApplicationFramework.CommandLineInterpreter aEx = new Eplan.EplApi.ApplicationFramework.CommandLineInterpreter();


                bool sRet = aEx.Execute("label", aExport);

                if (!sRet)
                    System.Windows.Forms.MessageBox.Show("Fehler beim Aufruf des Exportes.");
                else
                {
                    erg = true;
                }
            }

            catch
            {
                System.Windows.Forms.MessageBox.Show("Fehler");
                erg = false;
            }

            return erg;
        }


        catch (System.Exception excp)
        {
            System.Windows.Forms.MessageBox.Show(excp.ToString());
            erg = false;
            return erg;
        }
    }



    public long Import_Schema(string sPath)

    // SCRIPT zum Verteilen von Schemata
    // VORTEIL: vorhandene Schemata werden aktualisert !!!
    {
        try
        {
            string[] directoryEntries =
                System.IO.Directory.GetFileSystemEntries(sPath, "*.XML");

            foreach (string sFile in directoryEntries)
            {
                Eplan.EplApi.Base.Settings oSettings = new Eplan.EplApi.Base.Settings();
                try
                {
                    System.Windows.Forms.MessageBox.Show(sFile);
                    oSettings.ReadSettings(sFile);
                }
                catch
                {
                    //
                }
            }
            return 1;
        }
        catch (System.Exception excp)
        {
            System.Windows.Forms.MessageBox.Show(excp.ToString());
            return 0;
        }
    }
}